/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.tsp;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampRequestGenerator;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.util.encoders.Base64;

public class TspService {
    static final String TSP_URL = "http://tsp.pki.gov.kz";

    public static TimeStampResponse getTSTInfo(byte[] data, String hashAlg) throws Exception {
        HttpURLConnection con;
        MessageDigest md = MessageDigest.getInstance(hashAlg, "KALKAN");
        md.update(data);
        byte[] hash = md.digest();
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        reqGen.setReqPolicy(KNCAObjectIdentifiers.tsa_gost_policy.getId());
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = reqGen.generate(hashAlg, hash, nonce);
        byte[] reqData = request.getEncoded();
        String b64 = new String(Base64.encode((byte[])reqData));
        String method = "GET";
        if (method.equals("GET")) {
            URL tspUrl = new URL("http://tsp.pki.gov.kz/" + b64);
            con = (HttpURLConnection)tspUrl.openConnection();
        } else {
            URL tspUrl = new URL(TSP_URL);
            con = (HttpURLConnection)tspUrl.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setRequestProperty("Content-Type", "application/timestamp-query");
            OutputStream reqStream = con.getOutputStream();
            reqStream.write(reqData);
            reqStream.close();
        }
        InputStream respStream = con.getInputStream();
        TimeStampResponse response = new TimeStampResponse(respStream);
        response.validate(request);
        SignerId signerConstraints = response.getTimeStampToken().getSID();
        CMSSignedData cmsData = response.getTimeStampToken().toCMSSignedData();
        CertStore certs = cmsData.getCertificatesAndCRLs("Collection", "KALKAN");
        Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signerConstraints);
        Iterator<? extends Certificate> certIt = certCollection.iterator();
        if (!certIt.hasNext()) {
            throw new TSPException("Validating certificate not found");
        }
        X509Certificate cert = (X509Certificate)certIt.next();
        response.getTimeStampToken().validate(cert, "KALKAN");
        return response;
    }
}

