/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.sign;

import java.util.ArrayList;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.workspace.signer.SignException;
import kz.workspace.signer.Utils;
import kz.workspace.signer.dictionary.Errors;
import kz.workspace.signer.sign.SignCms;

public class SignProcessor {
    static final int TIME_TO_STOP_MS = 10000;
    public static final boolean IS_DEBUG = false;
    private static long calculatedTimeToSignMs;
    private static long startSignTime;
    private static long lastCheckTime;
    private static boolean inProcess;
    private static Object lock;

    private static void debugLog(String message) {
    }

    public static synchronized int getProcessPercent() {
        if (!inProcess) {
            return 100;
        }
        lastCheckTime = System.currentTimeMillis();
        long spentTime = System.currentTimeMillis() - startSignTime;
        long totalPlanTime = calculatedTimeToSignMs;
        SignProcessor.debugLog("calculatedTimeToSignMs:" + calculatedTimeToSignMs);
        long percent = Math.round((double)spentTime * 99.0 / (double)totalPlanTime);
        if (percent < 0L) {
            percent = 0L;
        }
        if (percent > 99L) {
            percent = 99L;
        }
        return (int)percent;
    }

    private static void resetValues() {
        calculatedTimeToSignMs = 0L;
        startSignTime = 0L;
        lastCheckTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<byte[]> signCMS(KalkanProvider provider, String keyFileName, String password, String signFileNames, String caCertB64, String alias, ArrayList<String> filesB64) throws SignException {
        try {
            Object object = lock;
            synchronized (object) {
                if (inProcess) {
                    throw new SignException(Errors.ALREADY_PROCESSING);
                }
                inProcess = true;
                SignProcessor.resetValues();
            }
            byte[] sled = Utils.b64decode(filesB64.get(0));
            calculatedTimeToSignMs = SignProcessor.getSignTimeMs(sled.length);
            lastCheckTime = startSignTime = System.currentTimeMillis();
            byte[] cms = SignCms.signCMS(provider, keyFileName, password, sled, signFileNames, caCertB64, true, alias, false, true, false);
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            res.add(cms);
            if (filesB64.size() > 1) {
                for (int i = 1; i < filesB64.size(); ++i) {
                    byte[] file = Utils.b64decode(filesB64.get(1));
                    byte[] signedFile = SignCms.signCMS(provider, keyFileName, password, file, null, null, true, alias, true, false, true);
                    res.add(signedFile);
                }
            }
            ArrayList<byte[]> arrayList = res;
            return arrayList;
        }
        catch (SignException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignException(Errors.PROCESS_ERROR, e.getMessage());
        }
        finally {
            inProcess = false;
        }
    }

    static void checkNeedStopProcess(boolean isStoppable) throws SignException {
        if (isStoppable && System.currentTimeMillis() - lastCheckTime > 10000L) {
            throw new SignException(Errors.PROCESS_STOPPED);
        }
    }

    public static long getSignTimeMs(int bodySizeBytes) {
        return 1000 + bodySizeBytes / 10485 * 2;
    }

    static {
        lock = new Object();
    }
}

