/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.sign;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DEREncodableVector;
import kz.gov.pki.kalkan.asn1.DERGeneralizedTime;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERPrintableString;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.DERUTF8String;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.workspace.signer.Utils;
import kz.workspace.signer.dictionary.EsedoConsts;
import kz.workspace.signer.model.KeyPair;
import kz.workspace.signer.ocsp.OcspService;
import kz.workspace.signer.sign.CadesUtils;
import kz.workspace.signer.sign.KaztokenProcessor;
import kz.workspace.signer.sign.SignProcessor;

public class SignCms {
    public static byte[] signCMS(KalkanProvider provider, String keyFileName, String password, byte[] dataToSign, String signFileNames, String caCertB64, boolean isStoppable, String alias, boolean useTsp, boolean useOcsp, boolean encapsulate) throws Exception {
        CMSSignedData signedData;
        X509Certificate x509Certificate;
        PrivateKey privateKey;
        Utils.printMemory(false);
        X509Certificate caCert = null;
        if (caCertB64 != null) {
            caCert = Utils.getCert(Utils.b64decode(caCertB64));
        }
        if (keyFileName != null) {
            File file = new File(keyFileName);
            FileInputStream f = new FileInputStream(file);
            byte[] buf = new byte[f.available()];
            f.read(buf, 0, f.available());
            KeyStore store = KeyStore.getInstance("PKCS12", provider.getName());
            store.load(new ByteArrayInputStream(buf), password.toCharArray());
            Enumeration<String> en = store.aliases();
            while (en.hasMoreElements()) {
                alias = en.nextElement().toString();
            }
            privateKey = (PrivateKey)store.getKey(alias, password.toCharArray());
            x509Certificate = (X509Certificate)store.getCertificate(alias);
        } else {
            KeyPair keyPair = KaztokenProcessor.getKeyPair(provider, password, alias);
            privateKey = keyPair.privateKey;
            x509Certificate = keyPair.certificate;
        }
        SignProcessor.checkNeedStopProcess(isStoppable);
        byte[] ocspResponse = null;
        if (useOcsp) {
            ocspResponse = OcspService.getOcspResp(x509Certificate, caCert);
        }
        ASN1EncodableVector attr = new ASN1EncodableVector();
        SignProcessor.checkNeedStopProcess(isStoppable);
        MessageDigest messageDigest = MessageDigest.getInstance(SignCms.getDigestAlg(x509Certificate), "KALKAN");
        messageDigest.reset();
        byte[] hash = messageDigest.digest(dataToSign);
        attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_SIGN_HASH), (ASN1Set)new DERSet((DEREncodable)new DEROctetString(hash))));
        Date currentDate = new Date();
        Attribute signTimeAttribute = new Attribute(new DERObjectIdentifier(EsedoConsts.OID_SIGN_DATE), (ASN1Set)new DERSet((DEREncodable)new DERGeneralizedTime(currentDate)));
        attr.add((DEREncodable)signTimeAttribute);
        if (signFileNames != null) {
            attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_SIGNED_FILE_NAMES), (ASN1Set)new DERSet((DEREncodable)new DERUTF8String(signFileNames))));
        }
        if (ocspResponse != null) {
            attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_OCSP_RESPONSE), (ASN1Set)new DERSet((DEREncodable)new DEROctetString(ocspResponse))));
        }
        attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_DN_NAME), (ASN1Set)new DERSet((DEREncodable)new X509Name(x509Certificate.getSubjectDN().getName()))));
        attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_CONTENT_TYPE), (ASN1Set)new DERSet((DEREncodable)new DERObjectIdentifier(EsedoConsts.OID_SIGNED_CONTENT_TYPE))));
        String descStr = "ESEDO";
        byte[] descr = new byte[descStr.length() + 1];
        System.arraycopy(descStr.getBytes(), 0, descr, 0, descStr.length());
        attr.add((DEREncodable)new Attribute(new DERObjectIdentifier(EsedoConsts.OID_SIGNING_DESCRIPTION), (ASN1Set)new DERSet((DEREncodable)new DERPrintableString(descr))));
        AttributeTable attributeTable = new AttributeTable((DEREncodableVector)attr);
        CertStore chainStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509Certificate)), "KALKAN");
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        generator.addSigner(privateKey, x509Certificate, "1.2.398.3.10.1.3", attributeTable, null);
        generator.addCertificatesAndCRLs(chainStore);
        CMSProcessableByteArray content = new CMSProcessableByteArray(dataToSign);
        try {
            signedData = generator.generate((CMSProcessable)content, encapsulate, "KALKAN");
        }
        catch (OutOfMemoryError e) {
            Utils.printMemory(true);
            throw e;
        }
        Utils.printMemory(true);
        if (useTsp) {
            signedData = CadesUtils.applyCAdEST(signedData, x509Certificate);
        }
        byte[] signedDataEncoded = signedData.getEncoded();
        SignProcessor.checkNeedStopProcess(isStoppable);
        return signedDataEncoded;
    }

    public static String getDigestAlg(X509Certificate cert) {
        String sigOid;
        switch (sigOid = cert.getSigAlgOID()) {
            case "1.2.398.3.10.1.1.2.3.2": {
                return "GOST3411-2015-512";
            }
            case "1.2.398.3.10.1.1.2.3.1": {
                return "GOST3411-2015-256";
            }
            case "1.2.398.3.10.1.1.1.2": {
                return "GOST3411";
            }
            case "1.2.840.113549.1.1.11": {
                return "SHA256";
            }
        }
        throw new RuntimeException("Unsupported sign alg OID: " + sigOid);
    }
}

