/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.sign;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.workspace.signer.model.KeyInfo;
import kz.workspace.signer.model.KeyPair;

public class KaztokenProcessor {
    private static final String TOKEN_NAME = "DigiFlow LLP. KAZTOKEN 0";
    private static final String STORE_NAME = "AKKaztokenStore";

    public static ArrayList<KeyInfo> getKeysInfo(KalkanProvider kalkanProvider, String password) throws Exception {
        KeyStore store = KeyStore.getInstance(STORE_NAME, kalkanProvider.getName());
        store.load(new ByteArrayInputStream(TOKEN_NAME.getBytes("UTF-8")), KaztokenProcessor.getCharPassword(password));
        Enumeration<String> en = store.aliases();
        ArrayList<KeyInfo> res = new ArrayList<KeyInfo>();
        while (en.hasMoreElements()) {
            String alias = en.nextElement().toString();
            X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
            if (certificate == null) continue;
            KeyInfo keyInfo = new KeyInfo(alias, certificate.getSubjectDN().getName(), KaztokenProcessor.getDate(certificate.getNotAfter()), KaztokenProcessor.getAlg(certificate));
            res.add(keyInfo);
        }
        return res;
    }

    public static KeyPair getKeyPair(KalkanProvider kalkanProvider, String tokenPassword, String alias) throws Exception {
        KeyStore store = KeyStore.getInstance(STORE_NAME, kalkanProvider.getName());
        store.load(new ByteArrayInputStream(TOKEN_NAME.getBytes("UTF-8")), KaztokenProcessor.getCharPassword(tokenPassword));
        X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
        PrivateKey privateKey = (PrivateKey)store.getKey(alias, KaztokenProcessor.getCharPassword(tokenPassword));
        return new KeyPair(certificate, privateKey);
    }

    private static char[] getCharPassword(String password) {
        if (password != null && password.length() > 0) {
            return password.toCharArray();
        }
        return null;
    }

    private static String getAlg(X509Certificate certificate) {
        return certificate.getPublicKey().getAlgorithm();
    }

    private static String getDate(Date date) {
        return new SimpleDateFormat("dd.MM.yyyy").format(date);
    }
}

