/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.sign;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Hashtable;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.workspace.signer.tsp.TspService;

public class CadesUtils {
    public static CMSSignedData applyCAdEST(CMSSignedData signedData, X509Certificate x509Certificate) throws Exception {
        SignerId selector = new SignerId();
        selector.setSerialNumber(x509Certificate.getSerialNumber());
        selector.setIssuer(x509Certificate.getIssuerX500Principal());
        SignerInformation signerInfo = signedData.getSignerInfos().get(selector);
        Collection signerInfos = signedData.getSignerInfos().getSigners();
        signerInfos.remove(signerInfo);
        signerInfos.add(CadesUtils.addTimestampToken(signerInfo));
        SignerInformationStore signerInformationStore = new SignerInformationStore(signerInfos);
        return CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)signerInformationStore);
    }

    private static SignerInformation addTimestampToken(SignerInformation signerInfo) throws Exception {
        byte[] signature = signerInfo.getSignature();
        TimeStampResponse response = TspService.getTSTInfo(signature, "1.3.14.3.2.26");
        Hashtable<DERObjectIdentifier, Attribute> uht = new Hashtable<DERObjectIdentifier, Attribute>();
        ASN1InputStream asn1InputStream = new ASN1InputStream(response.getTimeStampToken().getEncoded());
        Attribute tstAttr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((DEREncodable)asn1InputStream.readObject()));
        uht.put(tstAttr.getAttrType(), tstAttr);
        asn1InputStream.close();
        AttributeTable uAttrTable = new AttributeTable(uht);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInfo, (AttributeTable)uAttrTable);
    }
}

