/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AccessDescription;
import kz.gov.pki.kalkan.asn1.x509.AuthorityInformationAccess;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.workspace.signer.Utils;
import kz.workspace.signer.common.BundleLog;
import kz.workspace.signer.ocsp.OcspInfo;

public class KNCAOCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ALLOWED_PERIOD_PROP = "knca.ocsp.allowedperiod";
    public static final String OCSP_RESPONDER_URL_PROP = "knca.ocspresponderURL";
    private static final int TIMEOUT = 5000;
    public static final String REV_REASON = "reason";
    public static final String REV_TIME = "time";
    private static int allowedPeriod;
    private Map<X500Principal, X509Certificate> caCertsMap;
    private String httpMethod;
    private byte[] nonce;
    private String hashAlgOid;
    private String provider;
    private BasicOCSPResp basicOCSPResponse;
    private OCSPResp OCSPResponse;

    public KNCAOCSPChecker(Map<X500Principal, X509Certificate> caCertsMap) {
        this(caCertsMap, CertificateID.HASH_GOST34311, "GET", null, "KALKAN");
    }

    public KNCAOCSPChecker(Map<X500Principal, X509Certificate> caCertsMap, String hashAlgOid, String httpMethod, byte[] nonce, String provider) {
        this.caCertsMap = caCertsMap == null ? Collections.emptyMap() : caCertsMap;
        this.httpMethod = httpMethod;
        this.nonce = nonce;
        this.hashAlgOid = hashAlgOid == null ? CertificateID.HASH_SHA1 : hashAlgOid;
        this.provider = provider == null ? "KALKAN" : provider;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate targetCert = (X509Certificate)cert;
        if (targetCert.getBasicConstraints() >= 0) {
            return;
        }
        String ocspUrlStr = System.getProperty(OCSP_RESPONDER_URL_PROP);
        try {
            BasicOCSPResp basicOCSPResp;
            X509Certificate issuerCert;
            OcspInfo ocspInfo = null;
            if (ocspUrlStr == null) {
                ocspInfo = this.getOCSPAccessLocation(targetCert);
            }
            if (ocspInfo != null) {
                ocspUrlStr = ocspInfo.ocspUrl;
            }
            if ((issuerCert = this.caCertsMap.get(targetCert.getIssuerX500Principal())) == null) {
                try {
                    issuerCert = Utils.getCertFromStream(Utils.getRequest(ocspInfo.caIssuersPath));
                }
                catch (Exception e) {
                    BundleLog.LOG.error(e.getMessage(), e);
                }
                if (issuerCert == null) {
                    throw new KalkanException((ErrorCode)OCSPCode.TARGET_CERT_ISSUER_NOT_FOUND);
                }
            }
            if (ocspUrlStr == null) {
                throw new KalkanException((ErrorCode)OCSPCode.OCSP_URL_NOT_DEFINED);
            }
            OCSPReq ocspReq = this.generateOCSPRequest(targetCert.getSerialNumber(), issuerCert);
            byte[] ocspReqBytes = ocspReq.getEncoded();
            OCSPResp ocspResp = this.sendOCSPRequest(ocspUrlStr, ocspReqBytes);
            if (ocspResp.getStatus() != 0) {
                throw new KalkanException((ErrorCode)OCSPCode.OCSP_RESP_NOT_SUCCESSFUL).set("status", (Object)ocspResp.getStatus());
            }
            this.OCSPResponse = ocspResp;
            this.basicOCSPResponse = basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
        }
        catch (Exception e) {
            throw new CertPathValidatorException(e);
        }
    }

    private void checkOCSPCert(X509Certificate ocspCert) throws KalkanException {
        X509Certificate topTrustedCert;
        X509Certificate trustedCert = this.caCertsMap.get(ocspCert.getIssuerX500Principal());
        if (trustedCert == null) {
            throw new KalkanException((ErrorCode)OCSPCode.OCSP_CERT_ISSUER_NOT_FOUND);
        }
        for (int i = 0; i < this.caCertsMap.size() && !trustedCert.getIssuerX500Principal().equals(trustedCert.getSubjectX500Principal()) && (topTrustedCert = this.caCertsMap.get(trustedCert.getIssuerX500Principal())) != null; ++i) {
            trustedCert = topTrustedCert;
        }
        HashSet<TrustAnchor> trustedAnchors = new HashSet<TrustAnchor>();
        trustedAnchors.add(new TrustAnchor(trustedCert, null));
        ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>(this.caCertsMap.values());
        chainList.add(ocspCert);
        CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(chainList);
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, this.provider);
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(ocspCert);
            HashSet<String> extKeyUsageSet = new HashSet<String>();
            extKeyUsageSet.add(KeyPurposeId.id_kp_OCSPSigning.getId());
            selector.setExtendedKeyUsage(extKeyUsageSet);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", this.provider);
            PKIXBuilderParameters builderParams = new PKIXBuilderParameters(trustedAnchors, (CertSelector)selector);
            builderParams.setSigProvider(this.provider);
            builderParams.addCertStore(certStore);
            builderParams.setRevocationEnabled(false);
            certPathBuilder.build(builderParams);
        }
        catch (Exception e) {
            throw new KalkanException((Throwable)e, (ErrorCode)OCSPCode.OCSP_CERT_NOT_VALIDATED);
        }
        if (ocspCert.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null) {
            throw new KalkanException((ErrorCode)OCSPCode.NOCHECK_EXT_NOT_FOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCSPResp sendOCSPRequest(String ocspUrlStr, byte[] ocspReqBytes) throws IOException, OCSPException {
        if (!ocspUrlStr.startsWith("http")) {
            BundleLog.LOG.info("OCSP url from cert: " + ocspUrlStr);
            ocspUrlStr = "http://" + ocspUrlStr;
            BundleLog.LOG.info("Formatted OCSP url: " + ocspUrlStr);
        }
        HttpURLConnection con = null;
        InputStream in = null;
        OutputStream os = null;
        OCSPResp ocspResp = null;
        try {
            if ("POST".equals(this.httpMethod)) {
                URL ocspUrl = new URL(ocspUrlStr);
                con = (HttpURLConnection)ocspUrl.openConnection();
                con.setConnectTimeout(5000);
                con.setReadTimeout(5000);
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/ocsp-request");
                os = con.getOutputStream();
                os.write(ocspReqBytes);
            } else if (ocspUrlStr.endsWith("/")) {
                URL ocspUrl = new URL(ocspUrlStr + URLEncoder.encode(Base64.encodeStr((byte[])ocspReqBytes), "UTF-8"));
                con = (HttpURLConnection)ocspUrl.openConnection();
            } else {
                URL ocspUrl = new URL(ocspUrlStr + "/" + URLEncoder.encode(Base64.encodeStr((byte[])ocspReqBytes), "UTF-8"));
                con = (HttpURLConnection)ocspUrl.openConnection();
            }
            if (con.getResponseCode() != 200) {
                throw new OCSPException("HTTP error code: " + con.getResponseCode());
            }
            if (!"application/ocsp-response".equals(con.getContentType())) {
                throw new OCSPException("Wrong content-type: " + con.getContentType());
            }
            in = con.getInputStream();
            ocspResp = new OCSPResp(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("[KNCACertPathChecker] Error closing instream: " + e.getMessage());
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    System.err.println("[KNCACertPathChecker] Error closing outstream: " + e.getMessage());
                }
            }
            if (con != null) {
                con.disconnect();
            }
        }
        return ocspResp;
    }

    private OcspInfo getOCSPAccessLocation(X509Certificate targetCert) throws IOException, KalkanException {
        String ocspUrl = null;
        String caIssuerPath = null;
        byte[] authInfoAccessExt = targetCert.getExtensionValue(X509Extensions.AuthorityInfoAccess.getId());
        if (authInfoAccessExt == null) {
            throw new KalkanException((ErrorCode)OCSPCode.AUTH_INFO_ACCESS_NOT_FOUND);
        }
        ASN1InputStream asn1In = new ASN1InputStream(authInfoAccessExt);
        DEROctetString octetString = (DEROctetString)asn1In.readObject();
        asn1In.close();
        ASN1InputStream seqIn = new ASN1InputStream(octetString.getOctets());
        DERObject derObj = seqIn.readObject();
        seqIn.close();
        AuthorityInformationAccess authInfoAccess = AuthorityInformationAccess.getInstance((Object)derObj);
        AccessDescription[] accessDescriptions = authInfoAccess.getAccessDescriptions();
        for (int i = 0; i < accessDescriptions.length; ++i) {
            if (accessDescriptions[i].getAccessMethod().equals((Object)X509ObjectIdentifiers.ocspAccessMethod)) {
                ocspUrl = accessDescriptions[i].getAccessLocation().getName().toString();
            }
            if (!accessDescriptions[i].getAccessMethod().equals((Object)X509ObjectIdentifiers.id_ad_caIssuers)) continue;
            caIssuerPath = accessDescriptions[i].getAccessLocation().getName().toString();
        }
        return new OcspInfo(caIssuerPath, ocspUrl);
    }

    private OCSPReq generateOCSPRequest(BigInteger serialNumber, X509Certificate issuerCert) throws OCSPException {
        OCSPReqGenerator gen = new OCSPReqGenerator();
        CertificateID certId = new CertificateID(this.hashAlgOid, issuerCert, serialNumber, this.provider);
        gen.addRequest(certId);
        if (this.nonce != null) {
            Hashtable<DERObjectIdentifier, X509Extension> exts = new Hashtable<DERObjectIdentifier, X509Extension>();
            X509Extension nonceExt = new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(this.nonce)));
            exts.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, nonceExt);
            gen.setRequestExtensions(new X509Extensions(exts));
        }
        OCSPReq req = gen.generate();
        return req;
    }

    public BasicOCSPResp getBasicOCSPResponse() {
        return this.basicOCSPResponse;
    }

    public OCSPResp getOCSPResponse() {
        return this.OCSPResponse;
    }

    static {
        Integer allowedPeriodPropValue = 300000;
        try {
            allowedPeriodPropValue = Integer.valueOf(System.getProperty(OCSP_ALLOWED_PERIOD_PROP, allowedPeriodPropValue.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        allowedPeriod = allowedPeriodPropValue >= 3600000 ? 3600000 : allowedPeriodPropValue;
    }
}

