/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.common;

import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public enum BundleLog {
    LOG;

    private static BundleContext CONTEXT;
    private LogService logService;

    public void discoverLogService() throws InvalidSyntaxException {
        CONTEXT = FrameworkUtil.getBundle(BundleLog.class).getBundleContext();
        String logServiceFilter = "(objectClass=" + LogService.class.getName() + ")";
        ServiceTracker logServiceTracker = new ServiceTracker(CONTEXT, CONTEXT.createFilter(logServiceFilter), null);
        logServiceTracker.open();
        this.logService = (LogService)logServiceTracker.getService();
        if (this.logService == null) {
            CONTEXT.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.logService = (LogService)logServiceTracker.getService(e.getServiceReference());
                    this.info("Found LogService while listening");
                }
            }, logServiceFilter);
        } else {
            this.info("Found LogService on load");
        }
    }

    public void info(String msg) {
        if (this.logService != null) {
            this.log(3, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void debug(String msg) {
        if (this.logService != null) {
            this.log(4, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void error(String msg, Throwable e) {
        if (this.logService != null) {
            this.log(1, msg, e);
        } else {
            System.err.println(msg);
            e.printStackTrace();
        }
    }

    public void log(int level, String msg) {
        if (this.logService != null) {
            this.logService.log(level, msg);
        } else {
            System.out.println(msg);
        }
    }

    public void log(int level, String msg, Throwable e) {
        if (this.logService != null) {
            this.logService.log(level, msg, e);
        } else {
            System.err.println(msg);
            e.printStackTrace();
        }
    }
}

