/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import kz.workspace.signer.applet.GUiConstants;
import kz.workspace.signer.applet.ProgramSettings;

class PasswordDialog
extends JDialog {
    private JPasswordField pass;
    private boolean okPressed = false;

    public PasswordDialog(String message) {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setTitle(ProgramSettings.getInstance().getDictionary("title.passwordWindow"));
        this.setBounds(100, 100, 450, 245);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        JButton ok = new JButton(ProgramSettings.getInstance().getDictionary("button.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PasswordDialog.this.setOkPressed(true);
                PasswordDialog.this.setVisible(false);
            }
        });
        ok.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        ok.setFont(new Font("Tahoma", 0, 14));
        ok.setContentAreaFilled(false);
        ok.setOpaque(true);
        ok.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        ok.setBounds(100, 169, 155, 35);
        panel.add(ok);
        JButton can = new JButton(ProgramSettings.getInstance().getDictionary("button.cancel"));
        can.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PasswordDialog.this.setOkPressed(false);
                PasswordDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PasswordDialog.this.setOkPressed(false);
                PasswordDialog.this.setVisible(false);
            }
        });
        can.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        can.setFont(new Font("Tahoma", 0, 14));
        can.setContentAreaFilled(false);
        can.setOpaque(true);
        can.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        can.setBounds(275, 169, 155, 35);
        panel.add(can);
        JPanel mesPanel = new JPanel();
        mesPanel.setBorder(new EtchedBorder(1, null, null));
        mesPanel.setBounds(15, 15, 415, 85);
        panel.add(mesPanel);
        mesPanel.setLayout(null);
        JLabel mesLabel = new JLabel();
        if (message != null && !message.isEmpty()) {
            mesLabel.setText("<html><p>" + message + "</p></html>");
        } else {
            mesLabel.setText("<html><p>" + ProgramSettings.getInstance().getDictionary("label.enterPass") + "</p></html>");
        }
        mesLabel.setForeground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        mesLabel.setFont(new Font("Tahoma", 1, 14));
        mesLabel.setHorizontalAlignment(0);
        mesLabel.setBounds(10, 0, 334, 85);
        mesPanel.add(mesLabel);
        this.pass = new JPasswordField();
        this.pass.enableInputMethods(true);
        this.pass.setFont(new Font("Tahoma", 1, 14));
        this.pass.setBounds(100, 124, 285, 30);
        panel.add(this.pass);
        final JLabel warningText = new JLabel("");
        warningText.setFont(new Font("Tahoma", 0, 11));
        warningText.setForeground(Color.RED);
        warningText.setBounds(15, 103, 415, 14);
        panel.add(warningText);
        KeyListener capsLockListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    warningText.setText("");
                    if (PasswordDialog.this.getToolkit().getLockingKeyState(20)) {
                        warningText.setText(ProgramSettings.getInstance().getDictionary("label.warningMessage.capsLock"));
                    }
                    if (!PasswordDialog.this.getInputContext().getLocale().getLanguage().equals("en")) {
                        if (!warningText.getText().equals("")) {
                            warningText.setText(warningText.getText() + "; ");
                        }
                        warningText.setText(warningText.getText() + ProgramSettings.getInstance().getDictionary("label.warningMessage.language"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.pass.addKeyListener(capsLockListener);
        JButton showPwdBtn = new JButton(new ImageIcon(PasswordDialog.class.getClassLoader().getResource("eye_16.png")));
        showPwdBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PasswordDialog.this.pass.setEchoChar('\u0000');
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PasswordDialog.this.pass.setEchoChar('*');
                PasswordDialog.this.pass.requestFocusInWindow();
            }
        });
        showPwdBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        showPwdBtn.setFont(new Font("Tahoma", 0, 14));
        showPwdBtn.setContentAreaFilled(false);
        showPwdBtn.setOpaque(true);
        showPwdBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        showPwdBtn.setBounds(385, 124, 45, 30);
        panel.add(showPwdBtn);
        showPwdBtn.addKeyListener(capsLockListener);
        ok.addKeyListener(capsLockListener);
        can.addKeyListener(capsLockListener);
        ImagePanel imgPanel = new ImagePanel();
        imgPanel.setBounds(15, 124, 75, 75);
        panel.add(imgPanel);
        this.setFrameToScreenCenter();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(ok);
        this.setVisible(true);
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void setOkPressed(boolean okPressed) {
        this.okPressed = okPressed;
    }

    public char[] getPassword() {
        return this.pass.getPassword();
    }

    class ImagePanel
    extends JPanel {
        private Image img = new ImageIcon(PasswordDialog.class.getClassLoader().getResource("password_icon.png")).getImage();

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, null);
        }
    }
}

