/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.workspace.signer.common.BundleLog;

public class Utils {
    public static X509Certificate getCert(byte[] cert) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
        return certificate;
    }

    public static X509Certificate getCertFromStream(InputStream cert) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(cert);
        return certificate;
    }

    public static byte[] loadFile(String urlPath) throws Exception {
        URL url = new URL(urlPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = null;){
            int n;
            is = url.openStream();
            byte[] byteChunk = new byte[4096];
            while ((n = is.read(byteChunk)) > 0) {
                baos.write(byteChunk, 0, n);
            }
        }
        return baos.toByteArray();
    }

    public static InputStream getRequest(String urlPath) throws Exception {
        URL url = new URL(urlPath);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        int status = con.getResponseCode();
        if (status == 302 || status == 301) {
            String location = con.getHeaderField("Location");
            URL newUrl = new URL(location);
            con = (HttpURLConnection)newUrl.openConnection();
        }
        return con.getInputStream();
    }

    public static byte[] b64decode(String b64) {
        if (b64 == null) {
            return null;
        }
        return Base64.decode((String)b64);
    }

    public static String bytesToBase64(byte[] bytes) {
        if (bytes != null) {
            return new String(java.util.Base64.getEncoder().encode(bytes));
        }
        return null;
    }

    public static int getMegaBytes(int bytes) {
        return bytes / 0x100000;
    }

    public static int getBytes(int megaBytes) {
        return megaBytes * 1024 * 1024;
    }

    public static void printMemory(boolean isWriteLog) {
        if (isWriteLog) {
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapMaxSize = Runtime.getRuntime().maxMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            String message = "heapSize:" + heapSize + "; heapMaxSize:" + heapMaxSize + "; heapFreeSize:" + heapFreeSize;
            BundleLog.LOG.info(message);
        }
    }
}

