/*
 * Decompiled with CFR 0.152.
 */
package kz.workspace.signer;

import java.util.ArrayList;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.workspace.signer.SignException;
import kz.workspace.signer.Utils;
import kz.workspace.signer.applet.PasswordDialogService;
import kz.workspace.signer.common.BundleLog;
import kz.workspace.signer.common.BundleProvider;
import kz.workspace.signer.model.KeyInfo;
import kz.workspace.signer.sign.KaztokenProcessor;
import kz.workspace.signer.sign.SignProcessor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;

public class ModuleServiceImpl
implements ModuleService {
    private static final String METHOD_SIGN = "sign";
    private static final String METHOD_GET_KAZTOKEN_KEYS = "getKaztokenKeys";

    public String process(String jsonString, String jsonAddInfo) {
        String ret;
        JSONStringer stringer = new JSONStringer();
        JSONObject jsonObj = new JSONObject(jsonString);
        String jsonMethod = jsonObj.optString("method");
        try {
            switch (jsonMethod) {
                case "sign": {
                    ret = this.processCreateCmsSignature(jsonObj);
                    break;
                }
                case "getKaztokenKeys": {
                    ret = this.processGetKaztokenKeys(jsonObj);
                    break;
                }
                default: {
                    ret = stringer.object().key("code").value(500L).key("message").value((Object)"Wrong method. Try 'createCMSSignature'").endObject().toString();
                    break;
                }
            }
        }
        catch (SignException e) {
            e.printStackTrace();
            ret = stringer.object().key("code").value(500L).key("message").value((Object)e.getMessage()).endObject().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            ret = stringer.object().key("code").value(500L).key("message").value((Object)message).endObject().toString();
        }
        BundleLog.LOG.info("method res:" + ret);
        return ret;
    }

    private String processCreateCmsSignature(JSONObject jsonObj) {
        JSONObject jsonArgs = jsonObj.getJSONObject("args");
        String alias = null;
        String storagePath = null;
        String password = null;
        boolean isKaztoken = jsonArgs.optBoolean("isKaztoken", false);
        password = PasswordDialogService.getKeyPassword();
        if (isKaztoken) {
            alias = jsonArgs.optString("alias");
        } else {
            storagePath = jsonArgs.optString("storagePath");
        }
        String issuerCert = jsonArgs.optString("issuerCert", null);
        String signFileNames = jsonArgs.optString("fileNames", null);
        ArrayList<String> filesB64 = new ArrayList<String>();
        JSONArray jsonArray = jsonArgs.optJSONArray("files");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                filesB64.add(jsonArray.getString(i));
            }
        }
        ArrayList<byte[]> res = SignProcessor.signCMS((KalkanProvider)BundleProvider.KALKANCRYPT.getProvider(), storagePath, password, signFileNames, issuerCert, alias, filesB64);
        ArrayList<String> signatures = new ArrayList<String>();
        for (byte[] data : res) {
            signatures.add(Utils.bytesToBase64(data));
        }
        return new JSONStringer().object().key("code").value(200L).key("body").value(signatures).endObject().toString();
    }

    private String processGetKaztokenKeys(JSONObject jsonObj) throws Exception {
        String password = PasswordDialogService.getKeyPassword();
        ArrayList<KeyInfo> keys = KaztokenProcessor.getKeysInfo((KalkanProvider)BundleProvider.KALKANCRYPT.getProvider(), password);
        return new JSONStringer().object().key("code").value(200L).key("body").value(keys).endObject().toString();
    }
}

